<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model 
{

    protected $table = 'lessons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'description', 'lesson_number');

    public function training()
    {
        return $this->belongsTo('Training', 'training_id');
    }

    public function supporting_material()
    {
        return $this->hasMany('SupportingMaterials', 'lesson_id');
    }

    public function lessons_section()
    {
        return $this->hasMany('LessonSection', 'lesson_id');
    }

}